
uniform sampler2D noisetex;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform vec3 cameraPosition;
uniform float frameTimeCounter;
uniform float wetnessCustom;

uniform vec2 taaOffset;

#ifndef MC_GL_VENDOR_INTEL
	#define attribute in
#endif

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;
attribute vec4 at_tangent;

out vec4 tint;
out vec2 texcoord;
out vec3 minecraftPos;
out vec3 viewPos;

flat out mat3 tbnMatrix;

flat out uint materialIDs;

out vec2 blockLight;

#include "/lib/Head/Common.inc"

#if defined PARALLAX || ANISOTROPIC_FILTER > 0
	out vec2 tileCoord;
	flat out vec2 tileOffset;
	flat out vec2 tileScale;
#endif

#define PLANTS_WAVE_EFFECTS
//#define PLANTS_TOUCH_EFFECTS

void main() {
	tint = gl_Color;
	texcoord = gl_MultiTexCoord0.xy;

	blockLight = saturate(gl_MultiTexCoord1.xy * rcp(240.0));

	#if defined PARALLAX || ANISOTROPIC_FILTER > 0
		vec2 midCoord = (gl_TextureMatrix[0] * mc_midTexCoord).xy;
		vec2 minMidCoord = texcoord - midCoord;
		tileOffset = min(texcoord, midCoord - minMidCoord);
		tileScale = abs(minMidCoord) * 2.0;
		tileCoord = sign(minMidCoord) * 0.5 + 0.5;
	#endif

	vec4 position = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;

    tbnMatrix[2] = normalize(gl_NormalMatrix * gl_Normal);
	#if defined MC_NORMAL_MAP || defined RAIN_SPLASH_EFFECT
		tbnMatrix[0] = normalize(gl_NormalMatrix * at_tangent.xyz);
		tbnMatrix[1] = cross(tbnMatrix[0], tbnMatrix[2]) * sign(at_tangent.w);
	#endif

	materialIDs = uint(max0(mc_Entity.x - 1e4));

	#ifdef MOD_BLOCK_SUPPORT
	#endif
	/*
    switch(int(mc_Entity.x)) {
    //grass
	    case 31: case 59: case 37: case 175: case 176: case 6:
            materialIDs = 2;
            break;
    //leaves
	    case 18: case 161:
            materialIDs = 3;
            break;
	//lightMisc
		case 7103: case 7115:
			materialIDs = 20;
			break;
    //torch
		case 50: case 7010:
            materialIDs = 21;
            break;
    //fire
		case 10:
            materialIDs = 22;
            break;
    //glowstone and lamp
        case 89:
            materialIDs = 23;
            break;
	//sealantern
		case 169: case 7011:
			materialIDs = 24;
			break;
    //redstone
		case 55: case 7012:
            materialIDs = 25;
            break;
    //soulfire
        case 7100:
            materialIDs = 26;
            break;
    //amethyst
		case 7101:
            materialIDs = 27;
			break;
	//glowberry
		case 56:
			materialIDs = 28;
			break;
	//rails
		case 100:
			materialIDs = 29;
			break;
	//beaconCore
		case 138:
			materialIDs = 30;
			break;
	//sculk
		case 7102:
			materialIDs = 31;
			break;
	//glowLichen
		case 7105:
			materialIDs = 32;
			break;
	//lightMisc1
		case 7104:
			materialIDs = 41;
			break;
	//ores
		case 57:
			materialIDs = 50;
			break;
	//netherOres
		case 58:
			materialIDs = 51;
    }
	*/

	#ifdef PLANTS_TOUCH_EFFECTS
		if (materialIDs == 1 || materialIDs == 2) {
			if (length((position.xyz + vec3(0.0, 2.0, 0.0))) < 2.0) position.xz *= 1.0 + max0(5.0 / max(length((position.xyz + vec3(0.0, 2.0, 0.0)) * vec3(8.0, 2.0, 8.0) - vec3(0.0, 2.0, 0.0)), 2.0) - 0.625);
		}
		if (materialIDs == 4 || materialIDs == 5) {
			if (length(position.xyz) < 2.0) position.xz *= 1.0 + max0(5.0 / max(length(position.xyz * vec3(8.0, 2.0, 8.0)), 2.0) - 0.625);
		}
	#endif

	position.xyz += cameraPosition.xyz;

	#ifdef PLANTS_WAVE_EFFECTS
		const float tick = frameTimeCounter * PI;

		float grassWeight = step(gl_MultiTexCoord0.y, mc_midTexCoord.y);
		const float lightWeight = pow4(saturate(blockLight.y * 1.5 - 0.5));

		if (materialIDs == 5) {
			grassWeight *= 0.8;
		} else if (materialIDs == 4) {
			grassWeight = grassWeight * 0.8 + 0.8;
		}

		//Waving grass
		if (materialIDs == 1 || materialIDs == 3 || materialIDs == 4 || materialIDs == 5) {
			vec2 angleLight = vec2(0.0);
			vec2 angleHeavy = vec2(0.0);

			vec2 pn0 = position.xz;
			pn0.x -= frameTimeCounter * rcp(3.0);

			float stoch = textureBicubic(noisetex, pn0 * rcp(256.0)).x;
			//vec3 stochLarge = textureBicubic(noisetex, position.xz / 1536.0).xyz;

			vec2 pn = position.xz * vec2(2.0, 8.0);
			pn.x -= frameTimeCounter * 15.0;

			//vec3 stochLargeMoving = textureBicubic(noisetex, pn.xz / 2560.0).xyz;

			float p = position.x + sin(position.z * 0.5);
			p += textureBicubic(noisetex, position.xz * rcp(1536.0)).x * 5.0;

			float windStrength = 0.85 + 0.15 * wetnessCustom;
			float windStrengthRandom = textureBicubic(noisetex, pn * rcp(2560.0)).x;
			windStrengthRandom = pow(windStrengthRandom, 2.0 - wetnessCustom);
			windStrength *= mix(windStrengthRandom, 0.5f, wetnessCustom * 0.25f);

			angleLight.x += sin(frameTimeCounter * 5.5f - p * 1.1f + stoch * 21.0) * 5.0 + 5.0;
			angleLight.y += sin(frameTimeCounter * 5.9732f - p * 1.174f/* + stoch * lightLateralRandomization*/)/* * lightLateralAmplitude + lightLateralOffset*/;

			angleHeavy.x += sin(frameTimeCounter * 8.0 - p * 0.9f + stoch * 13.0) * 15.0 + 15.0;
			angleHeavy.y += sin(frameTimeCounter * 6.732f - p * 1.274f + stoch/* * heavyLateralRandomization*/) * 6.0/* + heavyLateralOffset*/;

			vec2 angle = mix(angleLight * clamp(windStrength * 2.0, 0.2, 1.0), angleHeavy, saturate(windStrength * 2.0 - 1.0));
			angle *= PI / 90.0;

			// Rotate block pivoting from bottom based on angle
			position.xyz += vec3(sin(angle.x), cos(angle.x + angle.y) - 1.0, sin(angle.y)) * grassWeight * lightWeight * 0.5f;
		}


		//Wheat//
		if (materialIDs == 2) {
			{
				const float speed = 0.1;

				float magnitude = sin(tick * rcp(28.0) + position.x + position.z) * 0.12 + 0.02;
				magnitude *= grassWeight * lightWeight * 0.2;
				float d0 = sin(tick * rcp(122.0 * speed)) * 3.0 - 1.5 + position.z;
				float d1 = sin(tick * rcp(152.0 * speed)) * 3.0 - 1.5 + position.x;
				float d2 = sin(tick * rcp(122.0 * speed)) * 3.0 - 1.5 + position.x;
				float d3 = sin(tick * rcp(152.0 * speed)) * 3.0 - 1.5 + position.z;
				position.x += sin(tick * rcp(28.0 * speed) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude;
				position.z += sin(tick * rcp(28.0 * speed) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude;
			}

		//small leaf movement
			{
				const float speed = 0.04;

				float magnitude = (sin((position.y + position.x) * 0.5 + tick * rcp(28.0)) * 0.025 + 0.075) * 0.2;
				magnitude *= grassWeight * lightWeight;
				float d0 = sin(tick * rcp(112.0 * speed)) * 3.0 - 1.5;
				float d1 = sin(tick * rcp(142.0 * speed)) * 3.0 - 1.5;
				//float d2 = sin(tick * rcp(112.0 * speed)) * 3.0 - 1.5;
				//float d3 = sin(tick * rcp(142.0 * speed)) * 3.0 - 1.5;
				position.x += sin(tick * rcp(18.0 * speed) + (-position.x + d0) * 1.6 + (position.z + d1) * 1.6) * magnitude * fma(wetnessCustom, 2.0, 1.0);
				position.z += sin(tick * rcp(18.0 * speed) + (position.z + d0) * 1.6 + (-position.x + d1) * 1.6) * magnitude * fma(wetnessCustom, 2.0, 1.0);
				position.y += sin(tick * rcp(11.0 * speed) + position.z + d0 + position.x + d1) * magnitude * rcp(3.0) * fma(wetnessCustom, 2.0, 1.0);
			}
		}
		

		//Leaves//
		if (materialIDs == 7) {
			const float speed = 0.05;
			
			float magnitude = (sin((position.y + position.x + tick * rcp(28.0 * speed))) * 0.15 + 0.15) * 0.12 * lightWeight;
			// magnitude *= grassWeight;
			magnitude *= lightWeight;
			float d0 = sin(tick * rcp(112.0 * speed)) * 3.0 - 1.5;
			float d1 = sin(tick * rcp(142.0 * speed)) * 3.0 - 1.5;
			float d2 = sin(tick * rcp(132.0 * speed)) * 3.0 - 1.5;
			float d3 = sin(tick * rcp(122.0 * speed)) * 3.0 - 1.5;
			position.x += sin(tick * rcp(18.0 * speed) + (-position.x + d0) * 1.6 + (position.z + d1) * 1.6) * magnitude * fma(wetnessCustom, 2.0, 1.0);
			position.z += sin(tick * rcp(17.0 * speed) + (position.z + d2) * 1.6 + (-position.x + d3) * 1.6) * magnitude * fma(wetnessCustom, 2.0, 1.0);
			position.y += sin(tick * rcp(11.0 * speed) + position.z + d2 + position.x + d3) * magnitude * 0.5 * fma(wetnessCustom, 2.0, 1.0);		
		}
	#endif

	#ifdef GENERAL_GRASS_FIX
		if ((abs(gl_Normal.x) > 0.01 && abs(gl_Normal.x) < 0.99 ||
			 abs(gl_Normal.y) > 0.01 && abs(gl_Normal.y) < 0.99 ||
			 abs(gl_Normal.z) > 0.01 && abs(gl_Normal.z) < 0.99)
			&& materialIDs < 0.5) materialIDs = 6;
	#endif

	if (materialIDs == 1 || materialIDs == 2 || materialIDs == 3 || materialIDs == 4 || materialIDs == 5) materialIDs = 6;

	minecraftPos = position.xyz;

	position.xyz -= cameraPosition.xyz;
	gl_Position = gl_ProjectionMatrix * gbufferModelView * position;
	
	#ifdef TAA_ENABLED
		gl_Position.xy += taaOffset * gl_Position.w;
	#endif

	viewPos = mat3(gl_ModelViewMatrix) * gl_Vertex.xyz + gl_ModelViewMatrix[3].xyz;
}